/*
 * Decompiled with CFR 0.152.
 */
package oracle.ias.cache;

import java.util.Hashtable;
import oracle.ias.cache.AggregateStatus;
import oracle.ias.cache.BitMap;
import oracle.ias.cache.CacheEvent;
import oracle.ias.cache.CacheEventListener;
import oracle.ias.cache.CacheHandle;
import oracle.ias.cache.CacheInternal;
import oracle.ias.cache.CacheLoader;
import oracle.ias.cache.CapacityPolicy;
import oracle.ias.cache.Child;
import oracle.ias.cache.Flag;
import oracle.ias.cache.ObjectStatus;
import oracle.ias.cache.OwnerInfo;
import oracle.ias.cache.PoolMgr;
import oracle.ias.cache.RegionCount;

class Mdslot {
    boolean wasCounted = false;
    int refcount = 0;
    long state = 0L;
    long objid = 0L;
    Object name;
    String qualifier;
    String parent;
    String group = null;
    int mygId = -1;
    long groupId = 0L;
    Child[] children;
    BitMap childFreeMap;
    int kidCount;
    Object object = null;
    long timeToLive = 0L;
    long idleTime = 0L;
    long ttlInterval = 0L;
    long ttlDefaultInterval;
    long version = 0L;
    OwnerInfo ownerInfo = null;
    Hashtable lockTable = null;
    Flag loadLock = new Flag();
    int regionNumber = 0;
    CacheEventListener[] eventHandlers = null;
    CacheLoader loader;
    ClassLoader userClassLoader;
    boolean loaderInherit = false;
    boolean[] eventDefault;
    String extension = null;
    String path;
    String fileName = null;
    int mdRecNum;
    int instNum = -1;
    long overFlow;
    PoolMgr poolMgr;
    ObjectStatus objStatus = new ObjectStatus();
    AggregateStatus aggStatus = null;
    boolean isFile = false;
    long oldObjid = 0L;
    long oldSize = 0L;
    RegionCount[] regionCount = null;
    CapacityPolicy capacityPolicy = null;
    Hashtable userAttrs = null;

    void free() {
        this.wasCounted = false;
        this.name = null;
        this.qualifier = null;
        this.object = null;
        this.group = null;
        this.extension = null;
        this.ownerInfo = null;
        this.lockTable = null;
        this.state = 1L;
        this.objid = CacheHandle.updateid(this.objid);
        this.groupId = 0L;
        this.mygId = -1;
        this.version = 0L;
        this.timeToLive = 0L;
        this.ttlInterval = 0L;
        this.idleTime = 0L;
        this.regionNumber = 0;
        this.loaderInherit = false;
        this.instNum = -1;
        this.fileName = null;
        this.eventHandlers = null;
        this.oldSize = 0L;
        this.oldObjid = 0L;
        this.isFile = false;
        this.regionCount = null;
        this.capacityPolicy = null;
        this.userAttrs = null;
        this.objStatus.reset();
        if (this.aggStatus != null) {
            this.aggStatus.clear();
        }
    }

    public void printSlot() {
        if (this.name != null) {
            System.out.println(" Qualifier=" + this.qualifier + " Name=" + this.name + " ObjId=" + this.objid + " Group=" + this.group + " Parent=" + this.parent + " KidCount=" + this.kidCount + " RefCount=" + this.refcount + " Version=" + this.version + " TimeToLive=" + this.timeToLive + " IdleTime=" + this.idleTime + " TtlInterval=" + this.ttlInterval + " DefaultTtlInterval=" + this.ttlDefaultInterval + " CacheLoader=" + this.loader + " CacheEventHandlers=" + this.getEventHandlers() + " State=" + Mdslot.getStateString(this.state) + " Region id=" + this.regionNumber + " Object =" + this.object + " PoolMgr=" + this.poolMgr + " File name=" + this.fileName + " instNum=" + this.instNum + " mdRecNum=" + this.mdRecNum + " oldSize=" + this.oldSize + " status=" + this.objStatus.toString() + " ownerinfo=" + this.ownerInfo + " userAttributes=" + this.userAttrs);
        }
    }

    void dump() {
        CacheInternal.trace(" Qualifier=" + this.qualifier + " Name=" + this.name + " ObjId=" + this.objid + " Group=" + this.group + " Parent=" + this.parent + " KidCount=" + this.kidCount + " RefCount=" + this.refcount + " Version=" + this.version + " TimeToLive=" + this.timeToLive + " IdleTime=" + this.idleTime + " TtlInterval=" + this.ttlInterval + " DefaultTtlInterval=" + this.ttlDefaultInterval + " CacheLoader=" + this.loader + " CapacityPolicy=" + this.capacityPolicy + " CacheEventHandlers=" + this.getEventHandlers() + " State=" + Mdslot.getStateString(this.state) + " Region id=" + this.regionNumber + " Object =(" + this.object + ")" + " PoolMgr=" + this.poolMgr + " File name=" + this.fileName + " instNum=" + this.instNum + " mdRecNum=" + this.mdRecNum + " oldSize=" + this.oldSize + " status=" + this.objStatus + " ownerinfo=" + this.ownerInfo + " userAttributes=" + this.userAttrs);
    }

    static String getStateString(long l) {
        String[] stringArray = new String[]{"FREE", "LOADED", "LOADING", "NEEDLOAD", "VALID", "UPDATEALL", "INMEMORY", "GROUP", "ONDISK", "DISTRIBUTE", "NEEDVERIFY", "REPLY", "DISKONLY", "DISKABLE", "MEMORY", "REPLACED", "ORIGINAL", "SYNCUP", "FINDONLY", "ATTRSET", "SYNCDEF", "NOWAIT", "TTLDESTROY", "WRITEONLY", "LOADER", "STREAM", "REMOTELOAD", "NOTDEFINED", "REGION", "DISABLED", "ALLOWNULL", "MEASURESIZE", "LISTLOAD", "INV_TIMEOUT", "INV_REMOVED"};
        long l2 = l;
        StringBuffer stringBuffer = new StringBuffer(Long.toHexString(l) + " ");
        for (int i = 0; i < 64; ++i) {
            if ((l2 & 1L) == 1L) {
                stringBuffer.append(stringArray[i] + ",");
            }
            l2 >>= 1;
        }
        return stringBuffer.toString();
    }

    private String getEventHandlers() {
        String string = "";
        if (this.eventHandlers == null) {
            return "None";
        }
        for (int i = 0; i < 6; ++i) {
            string = string + CacheEvent.getEventName(i) + ":" + this.eventHandlers[i];
        }
        return string;
    }
}

